<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Server Monitoring Dashboard</title>
<style>
body {
    font-family: "Segoe UI", Arial, sans-serif;
    background: #f3f6fa;
    margin: 0;
    padding: 0;
}
header {
    background: #0078d7;
    color: white;
    padding: 15px 20px;
    text-align: center;
    font-size: 1.5em;
}
.container {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    padding: 20px;
    justify-items: center;
}
iframe {
    width: 100%;
    height: 660px;
    border: 2px solid #0078d7;
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.15);
    overflow: hidden;
    scrollbar-width: none;
}
iframe::-webkit-scrollbar { display: none; }

footer {
    text-align: center;
    color: #666;
    padding: 15px;
    border-top: 1px solid #ddd;
    background: #fff;
}
.refresh-btn {
    display: inline-block;
    background: #0078d7;
    color: white;
    padding: 8px 16px;
    border-radius: 6px;
    text-decoration: none;
    font-weight: bold;
    transition: background 0.2s;
}
.refresh-btn:hover { background: #005da1; }
.last-updated {
    text-align: right;
    max-width: 90%;
    margin: 10px auto;
    font-size: 0.9em;
    color: #555;
}

/* 🌐 Responsive Design */
@media (max-width: 1200px) {
    .container { grid-template-columns: repeat(1, 1fr); }
    iframe { height: 650px; width: 80%;}
}
@media (max-width: 768px) {
    .container { grid-template-columns: 1fr; }
    iframe { width: 80%; }
}
/* 1 per row on small screens (mobile) */
@media (max-width: 900px) {
    .container {
        grid-template-columns: 1fr;
    }
}

/* Adjust iframe height for mobile */
@media (max-width: 900px) {
    iframe {
        height: 550px;
    }
}
</style>
</head>
<body>

<header>Server Monitoring Dashboard</header>

<div style="text-align:center; margin:15px;">
  <a href="#" onclick="refreshAll();" class="refresh-btn">🔄 Refresh All</a>
</div>

<div class="container">
    <iframe src="server_status.php" title="Local Server"></iframe>
    <iframe src="https://hub8new.pfcd.ca/server-health/server_status.php" title="Hub8 Server"></iframe>
    <iframe src="https://iggy.boundlessaccelerator.ca/server-health/server_status.php" title="Boundless Accelerator"></iframe>
    <iframe src="https://control.regalideas.com/server-health/server_status.php" title="Regal-CRM"></iframe>
    <iframe src="https://crm.sandybayfreight.com/server-health/server_status.php" title="SandyBay CRM"></iframe>
    <iframe src="https://salesdmsi.desmaint.com/server-health/server_status.php" title="DMSI CRM"></iframe>
    <iframe src="https://control.tube-mac.com/server-health/server_status.php" title="TUBEMAC CRM"></iframe>
</div>

<div class="last-updated">
    Last Updated: <?= date('Y-m-d H:i:s') ?>
</div>

<footer>
    © <?= date('Y') ?> Server Health Dashboard • Auto-refresh every 5 minutes
</footer>

<script>
// Auto-refresh all iframes every 5 minutes
setInterval(refreshAll, 5 * 60 * 1000);

function refreshAll() {
    document.querySelectorAll("iframe").forEach(iframe => {
        iframe.src = iframe.src.split("?")[0] + "?t=" + new Date().getTime();
    });
    document.querySelector('.last-updated').innerText = 'Last Updated: ' + new Date().toLocaleString();
}

// 🧩 Auto-adjust iframe height dynamically
window.addEventListener('load', () => {
    document.querySelectorAll('iframe').forEach(iframe => {
        iframe.addEventListener('load', function() {
            try {
                // Access iframe document height
                const iframeDoc = this.contentDocument || this.contentWindow.document;
                const contentHeight = iframeDoc.body.scrollHeight;
                this.style.height = (contentHeight + 20) + 'px';
            } catch (e) {
                // For cross-domain iframes (e.g. other servers), fallback to a fixed height
                this.style.height = '650px';
            }
        });
    });
});
</script>


</body>
</html>
